#import "ManDrakeController.h"

@implementation ManDrakeController

- (void)awakeFromNib
{
	refreshTimer = NULL;
	[window center];
	[window makeKeyAndOrderFront: self];
}

- (IBAction)open:(id)sender
{
	int result;
	
    NSOpenPanel *oPanel = [NSOpenPanel openPanel];
	
	[oPanel setCanChooseDirectories:YES];
	[oPanel setCanChooseFiles: YES];
    [oPanel setAllowsMultipleSelection:NO];
    result = [oPanel runModalForDirectory:nil file:nil types:nil];
    if (result == NSOKButton) 
	{
		[manPathTextField setStringValue: [oPanel filename]];
		[editableTextField setString: [NSString stringWithContentsOfFile: [oPanel filename]] ];
		[self refresh: self];
    }
	else
		return;
	
}

- (IBAction)refresh:(id)sender
{
	NSString *mantext = [editableTextField string];
	char	groffcmd[] = "groff -Tps -man /tmp/mantext.man > /tmp/man.ps  2> /tmp/groff.log";
	
	[mantext writeToFile:@"/tmp/mantext.man" atomically: YES];
	
	system((char *)&groffcmd);
	
	NSImage *img = [[NSImage alloc] initWithContentsOfFile: @"/tmp/man.ps"];
	[preview setImage: img];
	
	[groffLog setString: [NSString stringWithContentsOfFile: @"/tmp/groff.log"]];
}

- (IBAction)revert:(id)sender
{
		[editableTextField setString: [NSString stringWithContentsOfFile: [manPathTextField stringValue]] ];
		[self refresh: self];

}

- (IBAction)save:(id)sender
{   
	if ([[manPathTextField stringValue] isEqualToString: @"No file loaded"])
	{
		[self saveAs: self];
	}
	else
	{
		NSString *mantext = [editableTextField string];
		[mantext writeToFile: [manPathTextField stringValue] atomically: YES];
	}
}

- (IBAction)saveAs:(id)sender
{
	NSSavePanel *sp;

	int runResult;

	/* create or get the shared instance of NSSavePanel */

	sp = [NSSavePanel savePanel];



	/* display the NSSavePanel */

	runResult = [sp runModalForDirectory:NSHomeDirectory() file:@""];

	if (runResult == NSOKButton)
	{
		if (![[editableTextField string] writeToFile:[sp filename] atomically:YES])
		{
			NSBeep();
		}
		else
			[manPathTextField setStringValue: [sp filename]];
	}

}

- (IBAction)scaleChanged:(id)sender
{

	NSString *scaleText = [scalePopupMenu titleOfSelectedItem];
	
	if ([scaleText isEqualToString: @"Proportionally"])
	{
		[preview setImageScaling: NSScaleProportionally];
	}
	else if ([scaleText isEqualToString: @"To Fit"])
	{
		[preview setImageScaling: NSScaleToFit];
	}
	else if ([scaleText isEqualToString: @"None"])
	{
		[preview setImageScaling: NSScaleNone];
	}
}

- (IBAction)viewLog:(id)sender
{
	[groffLogWindow center];
	[groffLogWindow makeKeyAndOrderFront: self];
}

#pragma mark -

- (void)textDidChange:(NSNotification *)aNotification
{
	NSString *refreshText = [refreshPopupMenu titleOfSelectedItem];

	if ([refreshText isEqualToString: @"Delayed"])
	{
		if (refreshTimer != NULL)
		{
			[refreshTimer invalidate];
			refreshTimer = NULL;
		}
		refreshTimer = [NSTimer scheduledTimerWithTimeInterval:0.3 target:self selector:@selector(updateView) userInfo:nil repeats:NO];
	
	}
	else if ([refreshText isEqualToString: @"Live"])
	{
		[self refresh: self];
	}
}

- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
{
	[manPathTextField setStringValue: filename];
	[editableTextField setString: [NSString stringWithContentsOfFile: filename] ];
	[self refresh: self];
	return TRUE;
}

- (void)updateView
{
	[self refresh: self];
	refreshTimer = NULL;
	[refreshTimer invalidate];
}

@end
